<?php
session_start();

if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

require_once '../api/config.php';
$conn = getDBConnection();

$userId = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($userId <= 0) {
    header('Location: users.php');
    exit;
}

// Ensure is_blocked column exists (simple migration)
try {
    $checkCol = $conn->query("SHOW COLUMNS FROM users LIKE 'is_blocked'");
    if (!$checkCol->fetch()) {
        $conn->exec("ALTER TABLE users ADD COLUMN is_blocked TINYINT(1) NOT NULL DEFAULT 0");
    }
} catch (Exception $e) {
    // ignore
}

// Fetch user
$stmt = $conn->prepare(
    "SELECT u.*, 
            (SELECT COUNT(*) FROM products p WHERE p.seller_id = u.id) AS total_products,
            (SELECT COUNT(*) FROM products p WHERE p.seller_id = u.id AND p.status = 'approved') AS approved_products,
            (SELECT COUNT(*) FROM products p WHERE p.seller_id = u.id AND p.status = 'pending') AS pending_products
     FROM users u
     WHERE u.id = ?"
);
$stmt->execute([$userId]);
$user = $stmt->fetch();

if (!$user) {
    header('Location: users.php');
    exit;
}

// Fetch user's products
$stmt = $conn->prepare(
    "SELECT p.* 
     FROM products p
     WHERE p.seller_id = ?
     ORDER BY p.created_at DESC"
);
$stmt->execute([$userId]);
$products = $stmt->fetchAll();

?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>User Details - Admin Panel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #2c3e50;
        }
        .sidebar a {
            color: #ecf0f1;
            text-decoration: none;
            padding: 15px;
            display: block;
        }
        .sidebar a:hover {
            background: #34495e;
        }
        .sidebar a.active {
            background: #3498db;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-2 sidebar p-0">
                <div class="p-3">
                    <h4 class="text-white">Mathbaria Shop</h4>
                    <p class="text-white-50 small">Admin Panel</p>
                </div>
                <nav>
                    <a href="index.php"><i class="bi bi-house"></i> Dashboard</a>
                    <a href="products.php"><i class="bi bi-box"></i> Products</a>
                    <a href="pending.php"><i class="bi bi-clock-history"></i> Pending Approval</a>
                    <a href="reports.php"><i class="bi bi-flag"></i> Reported Ads</a>
                    <a href="users.php" class="active"><i class="bi bi-people"></i> Users</a>
                    <a href="settings.php"><i class="bi bi-gear"></i> Settings</a>
                    <a href="pages.php"><i class="bi bi-file-text"></i> Pages</a>
                    <a href="logout.php"><i class="bi bi-box-arrow-right"></i> Logout</a>
                </nav>
            </div>

            <!-- Main Content -->
            <div class="col-md-10 p-4">
                <a href="users.php" class="btn btn-sm btn-secondary mb-3">&larr; Back to Users</a>
                <h2>User Details</h2>
                <hr>

                <div class="row">
                    <div class="col-md-4">
                        <div class="card mb-3">
                            <div class="card-header">
                                <h5 class="mb-0">Basic Info</h5>
                            </div>
                            <div class="card-body">
                                <p><strong>Name:</strong> <?php echo htmlspecialchars($user['name']); ?></p>
                                <p><strong>Phone:</strong> <?php echo htmlspecialchars($user['phone']); ?></p>
                                <p><strong>Union:</strong> <?php echo htmlspecialchars($user['union_name']); ?></p>
                                <p><strong>Registered:</strong> <?php echo date('d M Y, h:i A', strtotime($user['created_at'])); ?></p>
                                <p><strong>Status:</strong>
                                    <?php if (!empty($user['is_blocked'])): ?>
                                        <span class="badge bg-danger">Blocked</span>
                                    <?php else: ?>
                                        <span class="badge bg-success">Active</span>
                                    <?php endif; ?>
                                </p>
                            </div>
                        </div>

                        <div class="card mb-3">
                            <div class="card-header">
                                <h5 class="mb-0">Stats</h5>
                            </div>
                            <div class="card-body">
                                <p><strong>Total Products:</strong> <?php echo (int)$user['total_products']; ?></p>
                                <p><strong>Approved:</strong> <?php echo (int)$user['approved_products']; ?></p>
                                <p><strong>Pending:</strong> <?php echo (int)$user['pending_products']; ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-8">
                        <div class="card">
                            <div class="card-header d-flex justify-content-between align-items-center">
                                <h5 class="mb-0">User's Products</h5>
                            </div>
                            <div class="card-body">
                                <?php if (empty($products)): ?>
                                    <p class="text-muted">No products found for this user.</p>
                                <?php else: ?>
                                    <div class="table-responsive">
                                        <table class="table table-hover align-middle">
                                            <thead>
                                                <tr>
                                                    <th>ID</th>
                                                    <th>Title</th>
                                                    <th>Price</th>
                                                    <th>Category</th>
                                                    <th>Status</th>
                                                    <th>Created</th>
                                                    <th>Action</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php foreach ($products as $p): ?>
                                                    <tr>
                                                        <td><?php echo $p['id']; ?></td>
                                                        <td><?php echo htmlspecialchars($p['title']); ?></td>
                                                        <td>৳<?php echo number_format($p['price'], 2); ?></td>
                                                        <td><?php echo htmlspecialchars($p['category']); ?></td>
                                                        <td>
                                                            <span class="badge bg-<?php
                                                                echo $p['status'] === 'approved' ? 'success' :
                                                                    ($p['status'] === 'pending' ? 'warning text-dark' : 'secondary');
                                                            ?>">
                                                                <?php echo htmlspecialchars(ucfirst($p['status'])); ?>
                                                            </span>
                                                        </td>
                                                        <td><?php echo date('d M Y', strtotime($p['created_at'])); ?></td>
                                                        <td>
                                                            <a href="pending.php?id=<?php echo $p['id']; ?>" class="btn btn-sm btn-primary">
                                                                View
                                                            </a>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; ?>
                                            </tbody>
                                        </table>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>


