<?php
require_once '../config.php';

$chatId = $_GET['chat_id'] ?? null;

if (!$chatId) {
    sendResponse(false, 'Chat ID is required', null, 400);
}

$chatId = (int)$chatId;

try {
    $conn = getDBConnection();
    
    // Get messages for this chat
    $stmt = $conn->prepare(
        "SELECT * FROM messages 
         WHERE chat_id = ? 
         ORDER BY created_at ASC"
    );
    $stmt->execute([$chatId]);
    $messages = $stmt->fetchAll();
    
    // Format messages for response
    $formattedMessages = [];
    foreach ($messages as $msg) {
        $formattedMessages[] = [
            'id' => $msg['id'],
            'chat_id' => $msg['chat_id'],
            'sender_id' => $msg['sender_id'],
            'text' => $msg['text'],
            'type' => $msg['type'] ?? 'text',
            'seen' => (bool)$msg['seen'],
            'timestamp' => $msg['created_at'],
        ];
    }
    
    sendResponse(true, 'Messages retrieved successfully', [
        'messages' => $formattedMessages
    ]);
    
} catch (PDOException $e) {
    error_log("Chat API Error: " . $e->getMessage());
    sendResponse(false, 'Failed to retrieve messages: ' . $e->getMessage(), null, 500);
}

?>
