<?php
require_once '../config.php';

$userId = $_GET['user_id'] ?? null;

if (!$userId) {
    sendResponse(false, 'User ID is required', null, 400);
}

$userId = (int)$userId;

try {
    $conn = getDBConnection();
    
    // Get chats where user is buyer OR seller
    $stmt = $conn->prepare(
        "SELECT c.*, 
                p.title as product_title,
                p.price as product_price,
                GROUP_CONCAT(pi.image_path ORDER BY pi.image_order LIMIT 1) as product_image
         FROM chats c
         LEFT JOIN products p ON c.product_id = p.id
         LEFT JOIN product_images pi ON p.id = pi.product_id
         WHERE (c.buyer_id = ? OR c.seller_id = ?)
         GROUP BY c.id
         ORDER BY c.last_message_time DESC"
    );
    $stmt->execute([$userId, $userId]);
    $chats = $stmt->fetchAll();
    
    // Process product images
    foreach ($chats as &$chat) {
        if (!empty($chat['product_image'])) {
            $chat['product_image'] = rtrim(UPLOAD_URL, '/') . '/' . $chat['product_image'];
        } else {
            $chat['product_image'] = null;
        }
    }
    
    sendResponse(true, 'Chats retrieved successfully', [
        'chats' => $chats
    ]);
    
} catch (PDOException $e) {
    error_log("Chat API Error: " . $e->getMessage());
    sendResponse(false, 'Failed to retrieve chats: ' . $e->getMessage(), null, 500);
}

?>
