<?php
require_once '../config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse(false, 'Invalid request method', null, 405);
}

$chatId = isset($_POST['chat_id']) ? (int)$_POST['chat_id'] : 0;
$senderId = isset($_POST['sender_id']) ? (int)$_POST['sender_id'] : 0;
$text = trim($_POST['text'] ?? '');

if ($chatId <= 0 || $senderId <= 0) {
    sendResponse(false, 'Invalid chat ID or sender ID', null, 400);
}

if (empty($text)) {
    sendResponse(false, 'Message text is required', null, 400);
}

try {
    $conn = getDBConnection();
    
    // Verify chat exists and sender is part of the chat
    $stmt = $conn->prepare(
        "SELECT id FROM chats 
         WHERE id = ? AND (buyer_id = ? OR seller_id = ?)"
    );
    $stmt->execute([$chatId, $senderId, $senderId]);
    $chat = $stmt->fetch();
    
    if (!$chat) {
        sendResponse(false, 'Chat not found or unauthorized', null, 404);
    }
    
    // Insert message
    $stmt = $conn->prepare(
        "INSERT INTO messages (chat_id, sender_id, text, type, seen) 
         VALUES (?, ?, ?, 'text', 0)"
    );
    $stmt->execute([$chatId, $senderId, $text]);
    $messageId = $conn->lastInsertId();
    
    // Update chat's last message
    $stmt = $conn->prepare(
        "UPDATE chats 
         SET last_message = ?, last_message_time = NOW() 
         WHERE id = ?"
    );
    $stmt->execute([$text, $chatId]);
    
    sendResponse(true, 'Message sent successfully', [
        'message_id' => $messageId
    ], 201);
    
} catch (PDOException $e) {
    error_log("Chat API Error: " . $e->getMessage());
    sendResponse(false, 'Failed to send message: ' . $e->getMessage(), null, 500);
}

?>
