<?php
/**
 * Debug endpoint to see exactly what's being received
 * POST to this endpoint with multipart/form-data
 */
error_reporting(E_ALL);
ini_set('display_errors', 1);

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

$debug = [
    'method' => $_SERVER['REQUEST_METHOD'],
    'content_type' => $_SERVER['CONTENT_TYPE'] ?? 'not set',
    'content_length' => $_SERVER['CONTENT_LENGTH'] ?? 'not set',
    'post_data' => $_POST,
    'files_data' => $_FILES,
    'files_count' => count($_FILES),
    'raw_input' => file_get_contents('php://input'),
];

// Check each file
if (!empty($_FILES)) {
    foreach ($_FILES as $key => $file) {
        $debug['file_details'][$key] = [
            'name' => is_array($file['name']) ? $file['name'] : [$file['name']],
            'type' => is_array($file['type']) ? $file['type'] : [$file['type']],
            'size' => is_array($file['size']) ? $file['size'] : [$file['size']],
            'error' => is_array($file['error']) ? $file['error'] : [$file['error']],
            'tmp_name' => is_array($file['tmp_name']) ? $file['tmp_name'] : [$file['tmp_name']],
        ];
        
        // Check if files actually exist
        if (is_array($file['tmp_name'])) {
            foreach ($file['tmp_name'] as $idx => $tmp) {
                $debug['file_details'][$key]['exists'][$idx] = file_exists($tmp);
                if (file_exists($tmp)) {
                    $debug['file_details'][$key]['size_actual'][$idx] = filesize($tmp);
                }
            }
        } else {
            $debug['file_details'][$key]['exists'][0] = file_exists($file['tmp_name']);
            if (file_exists($file['tmp_name'])) {
                $debug['file_details'][$key]['size_actual'][0] = filesize($file['tmp_name']);
            }
        }
    }
}

// Try to save a test file if images[] is present
if (isset($_FILES['images'])) {
    require_once 'config.php';
    
    $uploadDirPath = UPLOAD_DIR;
    if (!file_exists($uploadDirPath)) {
        mkdir($uploadDirPath, 0755, true);
    }
    
    $debug['upload_dir'] = [
        'path' => $uploadDirPath,
        'exists' => file_exists($uploadDirPath),
        'writable' => is_writable($uploadDirPath),
    ];
    
    $files = $_FILES['images'];
    $isArray = is_array($files['name']);
    
    if ($isArray) {
        $count = count($files['name']);
        $debug['images_count'] = $count;
        
        for ($i = 0; $i < $count; $i++) {
            if ($files['error'][$i] === UPLOAD_ERR_OK) {
                $testFilename = 'debug_' . time() . '_' . $i . '_' . basename($files['name'][$i]);
                $testFilepath = $uploadDirPath . $testFilename;
                
                $debug['upload_attempt'][$i] = [
                    'source' => $files['tmp_name'][$i],
                    'destination' => $testFilepath,
                    'move_result' => move_uploaded_file($files['tmp_name'][$i], $testFilepath),
                    'file_exists_after' => file_exists($testFilepath),
                ];
                
                if (file_exists($testFilepath)) {
                    $debug['upload_attempt'][$i]['size'] = filesize($testFilepath);
                }
            } else {
                $debug['upload_attempt'][$i] = [
                    'error_code' => $files['error'][$i],
                    'error_message' => [
                        UPLOAD_ERR_INI_SIZE => 'UPLOAD_ERR_INI_SIZE',
                        UPLOAD_ERR_FORM_SIZE => 'UPLOAD_ERR_FORM_SIZE',
                        UPLOAD_ERR_PARTIAL => 'UPLOAD_ERR_PARTIAL',
                        UPLOAD_ERR_NO_FILE => 'UPLOAD_ERR_NO_FILE',
                        UPLOAD_ERR_NO_TMP_DIR => 'UPLOAD_ERR_NO_TMP_DIR',
                        UPLOAD_ERR_CANT_WRITE => 'UPLOAD_ERR_CANT_WRITE',
                        UPLOAD_ERR_EXTENSION => 'UPLOAD_ERR_EXTENSION',
                    ][$files['error'][$i]] ?? 'Unknown error',
                ];
            }
        }
    } else {
        // Single file
        if ($files['error'] === UPLOAD_ERR_OK) {
            $testFilename = 'debug_' . time() . '_' . basename($files['name']);
            $testFilepath = $uploadDirPath . $testFilename;
            
            $debug['upload_attempt'][0] = [
                'source' => $files['tmp_name'],
                'destination' => $testFilepath,
                'move_result' => move_uploaded_file($files['tmp_name'], $testFilepath),
                'file_exists_after' => file_exists($testFilepath),
            ];
        }
    }
}

echo json_encode($debug, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

