<?php
/**
 * Test script to manually insert an image record into product_images table
 * Usage: Run this in browser or via command line to test database insert
 */
require_once 'config.php';

header('Content-Type: application/json; charset=utf-8');

$conn = getDBConnection();

try {
    // Get a product ID (use the latest one)
    $stmt = $conn->query("SELECT id FROM products ORDER BY id DESC LIMIT 1");
    $product = $stmt->fetch();
    
    if (!$product) {
        echo json_encode([
            'success' => false,
            'message' => 'No products found. Please create a product first.',
        ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
        exit;
    }
    
    $productId = $product['id'];
    
    // Test database insert
    $testFilename = 'test_' . time() . '.jpg';
    $stmt = $conn->prepare("INSERT INTO product_images (product_id, image_path, image_order) VALUES (?, ?, ?)");
    $result = $stmt->execute([$productId, $testFilename, 0]);
    
    if ($result) {
        $insertedId = $conn->lastInsertId();
        
        // Verify
        $verifyStmt = $conn->prepare("SELECT * FROM product_images WHERE id = ?");
        $verifyStmt->execute([$insertedId]);
        $record = $verifyStmt->fetch();
        
        echo json_encode([
            'success' => true,
            'message' => 'Database insert test successful',
            'data' => [
                'product_id' => $productId,
                'inserted_id' => $insertedId,
                'filename' => $testFilename,
                'record' => $record,
            ],
        ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
        
        // Clean up test record
        $conn->prepare("DELETE FROM product_images WHERE id = ?")->execute([$insertedId]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Database insert failed',
        ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
    }
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage(),
        'error' => $e->getMessage(),
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
}

