<?php
session_start();

if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

require_once '../api/config.php';
$conn = getDBConnection();

// Ensure site_settings table exists
try {
    $conn->exec("CREATE TABLE IF NOT EXISTS site_settings (
        id INT AUTO_INCREMENT PRIMARY KEY,
        `key` VARCHAR(100) UNIQUE NOT NULL,
        `value` TEXT NULL,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        INDEX idx_key (`key`)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
} catch (Exception $e) {
    // ignore
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $settings = [
        'site_name' => trim($_POST['site_name'] ?? ''),
        'site_logo' => trim($_POST['site_logo'] ?? ''),
        'contact_phone' => trim($_POST['contact_phone'] ?? ''),
        'contact_email' => trim($_POST['contact_email'] ?? ''),
        'facebook_page' => trim($_POST['facebook_page'] ?? ''),
        'facebook_group' => trim($_POST['facebook_group'] ?? ''),
        'whatsapp_number' => trim($_POST['whatsapp_number'] ?? ''),
    ];

    foreach ($settings as $key => $value) {
        $stmt = $conn->prepare("INSERT INTO site_settings (`key`, `value`) VALUES (?, ?) ON DUPLICATE KEY UPDATE `value` = ?");
        $stmt->execute([$key, $value, $value]);
    }

    header('Location: settings.php?saved=1');
    exit;
}

// Get current settings
$stmt = $conn->query("SELECT `key`, `value` FROM site_settings");
$currentSettings = [];
while ($row = $stmt->fetch()) {
    $currentSettings[$row['key']] = $row['value'];
}

?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Settings - Admin Panel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #2c3e50;
        }
        .sidebar a {
            color: #ecf0f1;
            text-decoration: none;
            padding: 15px;
            display: block;
        }
        .sidebar a:hover {
            background: #34495e;
        }
        .sidebar a.active {
            background: #3498db;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-2 sidebar p-0">
                <div class="p-3">
                    <h4 class="text-white">Mathbaria Shop</h4>
                    <p class="text-white-50 small">Admin Panel</p>
                </div>
                <nav>
                    <a href="index.php"><i class="bi bi-house"></i> Dashboard</a>
                    <a href="products.php"><i class="bi bi-box"></i> Products</a>
                    <a href="pending.php"><i class="bi bi-clock-history"></i> Pending Approval</a>
                    <a href="reports.php"><i class="bi bi-flag"></i> Reported Ads</a>
                    <a href="users.php"><i class="bi bi-people"></i> Users</a>
                    <a href="settings.php" class="active"><i class="bi bi-gear"></i> Settings</a>
                    <a href="pages.php"><i class="bi bi-file-text"></i> Pages</a>
                    <a href="logout.php"><i class="bi bi-box-arrow-right"></i> Logout</a>
                </nav>
            </div>

            <!-- Main Content -->
            <div class="col-md-10 p-4">
                <h2>Site Settings</h2>
                <hr>

                <?php if (isset($_GET['saved'])): ?>
                    <div class="alert alert-success">Settings saved successfully.</div>
                <?php endif; ?>

                <div class="card">
                    <div class="card-body">
                        <form method="POST">
                            <div class="mb-3">
                                <label for="site_name" class="form-label">Site Name</label>
                                <input type="text" class="form-control" id="site_name" name="site_name" 
                                       value="<?php echo htmlspecialchars($currentSettings['site_name'] ?? 'Mathbaria Shop'); ?>" required>
                            </div>

                            <div class="mb-3">
                                <label for="site_logo" class="form-label">Site Logo URL</label>
                                <input type="url" class="form-control" id="site_logo" name="site_logo" 
                                       value="<?php echo htmlspecialchars($currentSettings['site_logo'] ?? ''); ?>" 
                                       placeholder="https://example.com/logo.png">
                                <small class="form-text text-muted">Full URL to your site logo image</small>
                            </div>

                            <hr>
                            <h5>Contact Information</h5>

                            <div class="mb-3">
                                <label for="contact_phone" class="form-label">Contact Phone</label>
                                <input type="tel" class="form-control" id="contact_phone" name="contact_phone" 
                                       value="<?php echo htmlspecialchars($currentSettings['contact_phone'] ?? ''); ?>" 
                                       placeholder="+8801234567890">
                            </div>

                            <div class="mb-3">
                                <label for="contact_email" class="form-label">Contact Email</label>
                                <input type="email" class="form-control" id="contact_email" name="contact_email" 
                                       value="<?php echo htmlspecialchars($currentSettings['contact_email'] ?? ''); ?>" 
                                       placeholder="contact@mathbariashop.com">
                            </div>

                            <hr>
                            <h5>Social Media & Links</h5>

                            <div class="mb-3">
                                <label for="facebook_page" class="form-label">Facebook Page URL</label>
                                <input type="url" class="form-control" id="facebook_page" name="facebook_page" 
                                       value="<?php echo htmlspecialchars($currentSettings['facebook_page'] ?? ''); ?>" 
                                       placeholder="https://facebook.com/yourpage">
                            </div>

                            <div class="mb-3">
                                <label for="facebook_group" class="form-label">Facebook Group URL</label>
                                <input type="url" class="form-control" id="facebook_group" name="facebook_group" 
                                       value="<?php echo htmlspecialchars($currentSettings['facebook_group'] ?? ''); ?>" 
                                       placeholder="https://facebook.com/groups/yourgroup">
                            </div>

                            <div class="mb-3">
                                <label for="whatsapp_number" class="form-label">WhatsApp Number</label>
                                <input type="tel" class="form-control" id="whatsapp_number" name="whatsapp_number" 
                                       value="<?php echo htmlspecialchars($currentSettings['whatsapp_number'] ?? ''); ?>" 
                                       placeholder="+8801234567890">
                                <small class="form-text text-muted">Include country code (e.g., +880)</small>
                            </div>

                            <div class="mt-4">
                                <button type="submit" class="btn btn-primary">
                                    <i class="bi bi-save"></i> Save Settings
                                </button>
                                <a href="index.php" class="btn btn-secondary">Cancel</a>
                            </div>
                        </form>
                    </div>
                </div>

                <div class="card mt-4">
                    <div class="card-header">
                        <h5 class="mb-0">Notification Settings (Future Feature)</h5>
                    </div>
                    <div class="card-body">
                        <p class="text-muted">SMS and Push notification configuration will be available here in future updates.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>


