<?php
session_start();

if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

require_once '../api/config.php';
$conn = getDBConnection();

// Ensure is_blocked column exists (simple migration)
try {
    $checkCol = $conn->query("SHOW COLUMNS FROM users LIKE 'is_blocked'");
    if (!$checkCol->fetch()) {
        $conn->exec("ALTER TABLE users ADD COLUMN is_blocked TINYINT(1) NOT NULL DEFAULT 0");
    }
} catch (Exception $e) {
    // ignore if no permission
}

// Handle block / unblock actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $userId = isset($_POST['user_id']) ? (int)$_POST['user_id'] : 0;
    $action = $_POST['action'] ?? '';

    if ($userId > 0 && in_array($action, ['block', 'unblock'], true)) {
        $isBlocked = $action === 'block' ? 1 : 0;
        $stmt = $conn->prepare("UPDATE users SET is_blocked = ? WHERE id = ?");
        $stmt->execute([$isBlocked, $userId]);
        header('Location: users.php?updated=1');
        exit;
    }
}

// Fetch all users with basic stats
$stmt = $conn->prepare(
    "SELECT u.id, u.name, u.phone, u.union_name, u.created_at, u.is_blocked,
            (SELECT COUNT(*) FROM products p WHERE p.seller_id = u.id) AS total_products,
            (SELECT COUNT(*) FROM products p WHERE p.seller_id = u.id AND p.status = 'approved') AS approved_products
     FROM users u
     ORDER BY u.created_at DESC"
);
$stmt->execute();
$users = $stmt->fetchAll();

?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Users - Admin Panel</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <style>
        .sidebar {
            min-height: 100vh;
            background: #2c3e50;
        }
        .sidebar a {
            color: #ecf0f1;
            text-decoration: none;
            padding: 15px;
            display: block;
        }
        .sidebar a:hover {
            background: #34495e;
        }
        .sidebar a.active {
            background: #3498db;
        }
    </style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-2 sidebar p-0">
                <div class="p-3">
                    <h4 class="text-white">Mathbaria Shop</h4>
                    <p class="text-white-50 small">Admin Panel</p>
                </div>
                <nav>
                    <a href="index.php"><i class="bi bi-house"></i> Dashboard</a>
                    <a href="products.php"><i class="bi bi-box"></i> Products</a>
                    <a href="pending.php"><i class="bi bi-clock-history"></i> Pending Approval</a>
                    <a href="reports.php"><i class="bi bi-flag"></i> Reported Ads</a>
                    <a href="users.php" class="active"><i class="bi bi-people"></i> Users</a>
                    <a href="settings.php"><i class="bi bi-gear"></i> Settings</a>
                    <a href="pages.php"><i class="bi bi-file-text"></i> Pages</a>
                    <a href="logout.php"><i class="bi bi-box-arrow-right"></i> Logout</a>
                </nav>
            </div>

            <!-- Main Content -->
            <div class="col-md-10 p-4">
                <h2>Users</h2>
                <hr>

                <div class="card">
                    <div class="card-header">
                        <h5>User List (<?php echo count($users); ?>)</h5>
                    </div>
                    <div class="card-body">
                        <?php if (empty($users)): ?>
                            <p class="text-muted">No users found.</p>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Name</th>
                                            <th>Phone</th>
                                            <th>Union</th>
                                            <th>Status</th>
                                            <th>Products</th>
                                            <th>Registered At</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($users as $u): ?>
                                            <tr>
                                                <td><?php echo $u['id']; ?></td>
                                                <td><?php echo htmlspecialchars($u['name']); ?></td>
                                                <td><?php echo htmlspecialchars($u['phone']); ?></td>
                                                <td><?php echo htmlspecialchars($u['union_name']); ?></td>
                                                <td>
                                                    <?php if (!empty($u['is_blocked'])): ?>
                                                        <span class="badge bg-danger">Blocked</span>
                                                    <?php else: ?>
                                                        <span class="badge bg-success">Active</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    মোট: <?php echo (int)$u['total_products']; ?><br>
                                                    অনুমোদিত: <?php echo (int)$u['approved_products']; ?>
                                                </td>
                                                <td><?php echo date('d M Y, h:i A', strtotime($u['created_at'])); ?></td>
                                                <td>
                                                    <a href="user_details.php?id=<?php echo $u['id']; ?>" class="btn btn-sm btn-primary mb-1">
                                                        Details
                                                    </a>
                                                    <form method="POST" style="display:inline-block">
                                                        <input type="hidden" name="user_id" value="<?php echo $u['id']; ?>">
                                                        <?php if (!empty($u['is_blocked'])): ?>
                                                            <button type="submit" name="action" value="unblock" class="btn btn-sm btn-success">
                                                                Unblock
                                                            </button>
                                                        <?php else: ?>
                                                            <button type="submit" name="action" value="block" class="btn btn-sm btn-warning">
                                                                Block
                                                            </button>
                                                        <?php endif; ?>
                                                    </form>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>


