<?php
require_once '../config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse(false, 'Invalid request method', null, 405);
}

$input = json_decode(file_get_contents('php://input'), true);

// Validate input
if (empty($input['phone']) || empty($input['password'])) {
    sendResponse(false, 'Phone number and password are required', null, 400);
}

$phone = preg_replace('/[^0-9]/', '', $input['phone']);
$password = $input['password'];

// Validate phone number
if (!preg_match('/^01\d{9}$/', $phone)) {
    sendResponse(false, 'Invalid phone number format', null, 400);
}

try {
    $conn = getDBConnection();
    
    // Get user
    $stmt = $conn->prepare("SELECT id, phone, password, name, union_name, created_at FROM users WHERE phone = ?");
    $stmt->execute([$phone]);
    $user = $stmt->fetch();
    
    if (!$user) {
        sendResponse(false, 'User not found. Please register first.', null, 404);
    }
    
    // Verify password
    if (!password_verify($password, $user['password'])) {
        sendResponse(false, 'Wrong password. Please try again.', null, 401);
    }
    
    // Remove password from response
    unset($user['password']);
    
    sendResponse(true, 'Login successful', [
        'user' => $user
    ]);
    
} catch(PDOException $e) {
    sendResponse(false, 'Login failed: ' . $e->getMessage(), null, 500);
}

?>

