<?php
require_once '../config.php';

$userId = $_GET['user_id'] ?? null;

if (!$userId) {
    sendResponse(false, 'User ID is required', null, 400);
}

$userId = (int)$userId;

try {
    $conn = getDBConnection();
    
    // Get chats where user is buyer OR seller
    $stmt = $conn->prepare(
        "SELECT c.*, 
                p.title as product_title,
                p.price as product_price,
                GROUP_CONCAT(pi.image_path ORDER BY pi.image_order LIMIT 1) as product_image
         FROM chats c
         LEFT JOIN products p ON c.product_id = p.id
         LEFT JOIN product_images pi ON p.id = pi.product_id
         WHERE (c.buyer_id = ? OR c.seller_id = ?)
         GROUP BY c.id
         ORDER BY COALESCE(c.last_message_time, c.created_at) DESC"
    );
    $stmt->execute([$userId, $userId]);
    $chats = $stmt->fetchAll();
    
    // Ensure created_at exists for all chats
    foreach ($chats as &$chat) {
        if (empty($chat['created_at'])) {
            $chat['created_at'] = $chat['last_message_time'] ?? date('Y-m-d H:i:s');
        }
        if (empty($chat['last_message_time'])) {
            $chat['last_message_time'] = $chat['created_at'];
        }
    }
    
    // Process product images
    foreach ($chats as &$chat) {
        if (!empty($chat['product_image'])) {
            $chat['product_image'] = rtrim(UPLOAD_URL, '/') . '/' . $chat['product_image'];
        } else {
            $chat['product_image'] = null;
        }
    }
    
    sendResponse(true, 'Chats retrieved successfully', [
        'chats' => $chats
    ]);
    
} catch (PDOException $e) {
    error_log("Chat API Error: " . $e->getMessage());
    sendResponse(false, 'Failed to retrieve chats: ' . $e->getMessage(), null, 500);
}

?>
