<?php
require_once '../config.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    sendResponse(false, 'Invalid request method', null, 405);
}

$chatId = isset($_POST['chat_id']) ? (int)$_POST['chat_id'] : 0;
$userId = isset($_POST['user_id']) ? (int)$_POST['user_id'] : 0;

if ($chatId <= 0 || $userId <= 0) {
    sendResponse(false, 'Invalid chat ID or user ID', null, 400);
}

try {
    $conn = getDBConnection();
    
    // Mark all messages in this chat as seen (except user's own messages)
    $stmt = $conn->prepare(
        "UPDATE messages 
         SET seen = 1 
         WHERE chat_id = ? AND sender_id != ? AND seen = 0"
    );
    $stmt->execute([$chatId, $userId]);
    $affectedRows = $stmt->rowCount();
    
    sendResponse(true, 'Messages marked as seen', [
        'updated_count' => $affectedRows
    ]);
    
} catch (PDOException $e) {
    error_log("Chat API Error: " . $e->getMessage());
    sendResponse(false, 'Failed to mark messages as seen: ' . $e->getMessage(), null, 500);
}

?>
