<?php
// Database Configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'rumhocom_ms'); // Change if needed
define('DB_PASS', 'rumman.38'); // Change if needed
define('DB_NAME', 'rumhocom_ms');
// Auto-detect base URL (for production/localhost)
$protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'] ?? 'localhost';

// Calculate base path more reliably
// We need to get the root path of the application, not including /api
$scriptPath = $_SERVER['SCRIPT_NAME'] ?? $_SERVER['PHP_SELF'] ?? '';

// Method 1: If script is in /api/..., go up two levels to get root
// Method 2: Use DOCUMENT_ROOT to get absolute path
$documentRoot = $_SERVER['DOCUMENT_ROOT'] ?? '';
$scriptFile = $_SERVER['SCRIPT_FILENAME'] ?? '';

// Try to determine base path from script location
// If script is at: /home/user/public_html/api/products/get_products.php
// And DOCUMENT_ROOT is: /home/user/public_html
// Then base path should be relative to DOCUMENT_ROOT

// Get relative path from document root
if (!empty($documentRoot) && !empty($scriptFile)) {
    $relativePath = str_replace($documentRoot, '', $scriptFile);
    // Remove /api/... from relative path
    $relativePath = preg_replace('#/api/.*$#', '', $relativePath);
    $basePath = $relativePath;
} else {
    // Fallback: use dirname method but go up enough levels
    $basePath = dirname(dirname(dirname($scriptPath)));
}

$basePath = str_replace('\\', '/', $basePath);
// Remove any double slashes
$basePath = preg_replace('#/+#', '/', $basePath);
$basePath = rtrim($basePath, '/');

// For production server, ensure correct path
// If basePath is empty or just '/', use root
if (empty($basePath) || $basePath === '/') {
    $basePath = '';
}

// Base URL for API
define('BASE_URL', "$protocol://$host$basePath/api/");

// Image upload directory (relative to api/config.php)
// Absolute path will be calculated when needed
define('UPLOAD_DIR_RELATIVE', '../uploads/products/');
define('UPLOAD_DIR', dirname(__DIR__) . '/uploads/products/');

// Auto-detect upload URL based on current server
// Use DOCUMENT_ROOT to get consistent base path
$documentRoot = $_SERVER['DOCUMENT_ROOT'] ?? '';
$scriptFile = $_SERVER['SCRIPT_FILENAME'] ?? '';

// Calculate UPLOAD_URL using the same method as basePath for consistency
if (!empty($documentRoot) && !empty($scriptFile)) {
    // Get the absolute path to uploads directory
    $uploadsAbsolutePath = dirname(__DIR__) . '/uploads/products/';
    // Get relative path from document root
    $relativeToRoot = str_replace($documentRoot, '', $uploadsAbsolutePath);
    $relativeToRoot = str_replace('\\', '/', $relativeToRoot);
    // Ensure it starts with /
    $relativeToRoot = '/' . ltrim($relativeToRoot, '/');
    $uploadUrlBase = $relativeToRoot;
} else {
    // Fallback: use calculated basePath (should be empty for root)
    $uploadUrlBase = $basePath ? "$basePath/uploads/products/" : "/uploads/products/";
}

// Ensure no double slashes in URL
$uploadUrlBase = preg_replace('#/+#', '/', $uploadUrlBase);
define('UPLOAD_URL', "$protocol://$host$uploadUrlBase");

// JWT Secret (change this to a random string)
define('JWT_SECRET', 'mathbaria_shop_secret_key_2024');

// Allowed image types
define('ALLOWED_IMAGE_TYPES', ['image/jpeg', 'image/jpg', 'image/png', 'image/webp']);
define('MAX_IMAGE_SIZE', 5 * 1024 * 1024); // 5MB

// Timezone
date_default_timezone_set('Asia/Dhaka');

// Database Connection
function getDBConnection() {
    try {
        $conn = new PDO(
            "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
            DB_USER,
            DB_PASS,
            [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false
            ]
        );
        return $conn;
    } catch(PDOException $e) {
        // Only send JSON response if this is an API request
        // Check if request is for API endpoint
        $isApiRequest = (strpos($_SERVER['REQUEST_URI'], '/api/') !== false || 
                        strpos($_SERVER['PHP_SELF'], '/api/') !== false);
        
        if ($isApiRequest) {
        http_response_code(500);
            header('Content-Type: application/json; charset=utf-8');
        echo json_encode(['success' => false, 'message' => 'Database connection failed']);
        exit;
        } else {
            // For non-API requests, throw exception so it can be caught by the calling code
            throw $e;
        }
    }
}

// CORS Headers - Only set for API requests
$isApiRequest = (strpos($_SERVER['REQUEST_URI'], '/api/') !== false || 
                strpos($_SERVER['PHP_SELF'], '/api/') !== false);

if ($isApiRequest) {
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');
header('Content-Type: application/json; charset=utf-8');

// Handle preflight requests
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
    }
}

// Response helper function
function sendResponse($success, $message, $data = null, $statusCode = 200) {
    http_response_code($statusCode);
    echo json_encode([
        'success' => $success,
        'message' => $message,
        'data' => $data
    ], JSON_UNESCAPED_UNICODE);
    exit;
}

// Create upload directory if not exists
$uploadDirPath = UPLOAD_DIR;
if (!file_exists($uploadDirPath)) {
    if (!mkdir($uploadDirPath, 0755, true)) {
        // Log error but don't break the application
        error_log("Failed to create upload directory: " . $uploadDirPath);
    } else {
        // Create .htaccess to prevent directory listing
        $htaccessFile = $uploadDirPath . '.htaccess';
        if (!file_exists($htaccessFile)) {
            file_put_contents($htaccessFile, "Options -Indexes\n");
        }
        // Create index.php to prevent directory listing
        $indexFile = $uploadDirPath . 'index.php';
        if (!file_exists($indexFile)) {
            file_put_contents($indexFile, "<?php\n// Directory listing disabled\n");
        }
    }
}

?>

