<?php
/**
 * Debug image URL generation
 */
require_once 'config.php';

header('Content-Type: application/json; charset=utf-8');
header('Access-Control-Allow-Origin: *');

$debug = [
    'config' => [
        'protocol' => (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http',
        'host' => $_SERVER['HTTP_HOST'] ?? 'localhost',
        'script_name' => $_SERVER['SCRIPT_NAME'] ?? '',
        'base_path' => dirname(dirname($_SERVER['SCRIPT_NAME'] ?? '')),
        'upload_url' => UPLOAD_URL,
        'upload_dir' => UPLOAD_DIR,
    ],
    'test' => []
];

try {
    $conn = getDBConnection();
    
    // Get a product with images
    $stmt = $conn->query(
        "SELECT p.id, p.title, 
                GROUP_CONCAT(pi.image_path ORDER BY pi.image_order SEPARATOR ',') as images
         FROM products p
         LEFT JOIN product_images pi ON p.id = pi.product_id
         WHERE p.status = 'approved' AND pi.image_path IS NOT NULL
         GROUP BY p.id
         LIMIT 1"
    );
    $product = $stmt->fetch();
    
    if ($product) {
        $images = $product['images'] ? explode(',', $product['images']) : [];
        $images = array_filter($images, function($img) {
            return !empty(trim($img));
        });
        
        foreach ($images as $img) {
            $img = trim($img);
            $fullUrl = rtrim(UPLOAD_URL, '/') . '/' . ltrim($img, '/');
            $filePath = UPLOAD_DIR . $img;
            
            $debug['test'][] = [
                'filename' => $img,
                'full_url' => $fullUrl,
                'file_path' => $filePath,
                'file_exists' => file_exists($filePath),
                'file_size' => file_exists($filePath) ? filesize($filePath) : 0,
                'is_readable' => file_exists($filePath) ? is_readable($filePath) : false,
            ];
        }
    } else {
        $debug['test'] = 'No products with images found';
    }
    
} catch (Exception $e) {
    $debug['error'] = $e->getMessage();
}

echo json_encode($debug, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

?>

