<?php
require_once '../config.php';

$conn = getDBConnection();

// Get query parameters
$union = $_GET['union'] ?? null;
$category = $_GET['category'] ?? null;
$status = $_GET['status'] ?? 'approved'; // Only show approved products to users

// Detect if users.is_blocked column exists (for hiding blocked users)
$hasBlockedColumn = false;
try {
    $colCheck = $conn->query("SHOW COLUMNS FROM users LIKE 'is_blocked'");
    if ($colCheck && $colCheck->fetch()) {
        $hasBlockedColumn = true;
    }
} catch (Exception $e) {
    $hasBlockedColumn = false;
}

try {
    $query = "SELECT p.*, 
              GROUP_CONCAT(pi.image_path ORDER BY pi.image_order SEPARATOR ',') as images,
              u.name as seller_name
              FROM products p
              LEFT JOIN product_images pi ON p.id = pi.product_id
              LEFT JOIN users u ON p.seller_id = u.id
              WHERE p.status = :status";
    
    $params = [':status' => $status];

    if ($hasBlockedColumn) {
        $query .= " AND (u.is_blocked IS NULL OR u.is_blocked = 0)";
    }
    
    if ($union) {
        $query .= " AND p.union_name = :union";
        $params[':union'] = $union;
    }
    
    if ($category) {
        $query .= " AND p.category = :category";
        $params[':category'] = $category;
    }
    
    $query .= " GROUP BY p.id ORDER BY p.created_at DESC";
    
    $stmt = $conn->prepare($query);
    $stmt->execute($params);
    $products = $stmt->fetchAll();
    
    // Process images
    foreach ($products as &$product) {
        $product['images'] = $product['images'] ? explode(',', $product['images']) : [];
        // Filter out empty strings and build full URLs
        $product['images'] = array_filter($product['images'], function($img) {
            return !empty(trim($img));
        });
        $product['images'] = array_map(function($img) use ($product) {
            $img = trim($img);
            // If image path doesn't start with http, prepend UPLOAD_URL
            if (!empty($img) && strpos($img, 'http') !== 0) {
                $fullUrl = rtrim(UPLOAD_URL, '/') . '/' . ltrim($img, '/');
                // Debug log
                error_log("Product {$product['id']} image: $img -> $fullUrl");
                return $fullUrl;
            }
            return $img;
        }, $product['images']);
        $product['images'] = array_values($product['images']); // Re-index array
        $product['price'] = (float)$product['price'];
        
        // Debug: Log first product's images
        if ($products[0]['id'] == $product['id']) {
            error_log("First product images: " . json_encode($product['images']));
        }
    }
    
    sendResponse(true, 'Products retrieved successfully', ['products' => $products]);
    
} catch(PDOException $e) {
    error_log("Product API Error: " . $e->getMessage());
    sendResponse(false, 'Failed to retrieve products: ' . $e->getMessage(), null, 500);
}

?>

