<?php
require_once '../config.php';

$conn = getDBConnection();

// Get user ID from query parameter
$userId = $_GET['user_id'] ?? null;

if (!$userId) {
    sendResponse(false, 'User ID is required', null, 400);
}

try {
    $query = "SELECT p.*, 
              GROUP_CONCAT(pi.image_path ORDER BY pi.image_order SEPARATOR ',') as images
              FROM products p
              LEFT JOIN product_images pi ON p.id = pi.product_id
              WHERE p.seller_id = :user_id
              GROUP BY p.id
              ORDER BY p.created_at DESC";
    
    $stmt = $conn->prepare($query);
    $stmt->execute([':user_id' => $userId]);
    $products = $stmt->fetchAll();
    
    // Process images
    foreach ($products as &$product) {
        $product['images'] = $product['images'] ? explode(',', $product['images']) : [];
        // Filter out empty strings and build full URLs
        $product['images'] = array_filter($product['images'], function($img) {
            return !empty(trim($img));
        });
        $product['images'] = array_map(function($img) {
            $img = trim($img);
            // If image path doesn't start with http, prepend UPLOAD_URL
            if (!empty($img) && strpos($img, 'http') !== 0) {
                return rtrim(UPLOAD_URL, '/') . '/' . ltrim($img, '/');
            }
            return $img;
        }, $product['images']);
        $product['images'] = array_values($product['images']); // Re-index array
        $product['price'] = (float)$product['price'];
    }
    
    sendResponse(true, 'User products retrieved successfully', ['products' => $products]);
    
} catch(PDOException $e) {
    error_log("User Products API Error: " . $e->getMessage());
    sendResponse(false, 'Failed to retrieve user products: ' . $e->getMessage(), null, 500);
}

?>

