<?php
// Quick Database Creation Script
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Database Configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'rumhocom_ms');
define('DB_PASS', 'rumman.38');
define('DB_NAME', 'rumhocom_ms');

echo "<!DOCTYPE html>";
echo "<html lang='bn'>";
echo "<head>";
echo "<meta charset='UTF-8'>";
echo "<meta name='viewport' content='width=device-width, initial-scale=1.0'>";
echo "<title>Create Database - Mathbaria Shop</title>";
echo "<link href='https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css' rel='stylesheet'>";
echo "<style>body { padding: 20px; background: #f5f5f5; }</style>";
echo "</head>";
echo "<body>";
echo "<div class='container'>";
echo "<div class='card shadow'>";
echo "<div class='card-body p-4'>";
echo "<h2 class='mb-4'>ডাটাবেস তৈরি করছি...</h2>";
echo "<hr>";

$success = false;
$errors = [];

try {
    // Step 1: Connect to MySQL (without database)
    echo "<h4>১. MySQL-এ কানেক্ট হচ্ছে...</h4>";
    $conn = new PDO(
        "mysql:host=" . DB_HOST . ";charset=utf8mb4",
        DB_USER,
        DB_PASS,
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
    echo "<div class='alert alert-success'>✅ MySQL-এ সফলভাবে কানেক্ট হয়েছে!</div>";
    
    // Step 2: Create database
    echo "<h4>২. ডাটাবেস তৈরি হচ্ছে...</h4>";
    $conn->exec("CREATE DATABASE IF NOT EXISTS `" . DB_NAME . "` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
    echo "<div class='alert alert-success'>✅ ডাটাবেস 'mathbariashop' তৈরি হয়েছে!</div>";
    
    // Step 3: Use database
    $conn->exec("USE `" . DB_NAME . "`");
    echo "<div class='alert alert-success'>✅ ডাটাবেস সিলেক্ট করা হয়েছে!</div>";
    
    // Step 4: Create tables
    echo "<h4>৩. টেবিল তৈরি হচ্ছে...</h4>";
    
    // Create users table
    $conn->exec("CREATE TABLE IF NOT EXISTS users (
        id INT AUTO_INCREMENT PRIMARY KEY,
        phone VARCHAR(15) UNIQUE NOT NULL,
        password VARCHAR(255) NOT NULL,
        name VARCHAR(100) NOT NULL,
        union_name VARCHAR(50) NOT NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        INDEX idx_phone (phone)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
    echo "<div class='alert alert-success'>✅ 'users' টেবিল তৈরি হয়েছে!</div>";
    
    // Create admins table
    $conn->exec("CREATE TABLE IF NOT EXISTS admins (
        id INT AUTO_INCREMENT PRIMARY KEY,
        username VARCHAR(50) UNIQUE NOT NULL,
        password VARCHAR(255) NOT NULL,
        name VARCHAR(100) NOT NULL,
        email VARCHAR(100),
        role ENUM('super_admin', 'admin', 'moderator') DEFAULT 'admin',
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        INDEX idx_username (username)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
    echo "<div class='alert alert-success'>✅ 'admins' টেবিল তৈরি হয়েছে!</div>";
    
    // Create products table
    $conn->exec("CREATE TABLE IF NOT EXISTS products (
        id INT AUTO_INCREMENT PRIMARY KEY,
        title VARCHAR(255) NOT NULL,
        description TEXT,
        price DECIMAL(10, 2) NOT NULL,
        category VARCHAR(50) NOT NULL,
        condition_type ENUM('new', 'used') NOT NULL DEFAULT 'used',
        union_name VARCHAR(50) NOT NULL,
        seller_id INT NOT NULL,
        seller_phone VARCHAR(15) NOT NULL,
        status ENUM('pending', 'approved', 'rejected') DEFAULT 'pending',
        approved_by INT NULL,
        approved_at TIMESTAMP NULL,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        FOREIGN KEY (seller_id) REFERENCES users(id) ON DELETE CASCADE,
        FOREIGN KEY (approved_by) REFERENCES admins(id) ON DELETE SET NULL,
        INDEX idx_seller (seller_id),
        INDEX idx_status (status),
        INDEX idx_union (union_name),
        INDEX idx_category (category),
        INDEX idx_created (created_at)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
    echo "<div class='alert alert-success'>✅ 'products' টেবিল তৈরি হয়েছে!</div>";
    
    // Create product_images table
    $conn->exec("CREATE TABLE IF NOT EXISTS product_images (
        id INT AUTO_INCREMENT PRIMARY KEY,
        product_id INT NOT NULL,
        image_path VARCHAR(255) NOT NULL,
        image_order INT DEFAULT 0,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE CASCADE,
        INDEX idx_product (product_id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
    echo "<div class='alert alert-success'>✅ 'product_images' টেবিল তৈরি হয়েছে!</div>";
    
    // Create chats table
    $conn->exec("CREATE TABLE IF NOT EXISTS chats (
        id INT AUTO_INCREMENT PRIMARY KEY,
        product_id INT NOT NULL,
        buyer_id INT NOT NULL,
        seller_id INT NOT NULL,
        last_message TEXT,
        last_message_time TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (product_id) REFERENCES products(id) ON DELETE CASCADE,
        FOREIGN KEY (buyer_id) REFERENCES users(id) ON DELETE CASCADE,
        FOREIGN KEY (seller_id) REFERENCES users(id) ON DELETE CASCADE,
        INDEX idx_buyer (buyer_id),
        INDEX idx_seller (seller_id),
        INDEX idx_product (product_id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
    echo "<div class='alert alert-success'>✅ 'chats' টেবিল তৈরি হয়েছে!</div>";
    
    // Create messages table
    $conn->exec("CREATE TABLE IF NOT EXISTS messages (
        id INT AUTO_INCREMENT PRIMARY KEY,
        chat_id INT NOT NULL,
        sender_id INT NOT NULL,
        text TEXT NOT NULL,
        type VARCHAR(20) DEFAULT 'text',
        seen TINYINT(1) DEFAULT 0,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (chat_id) REFERENCES chats(id) ON DELETE CASCADE,
        FOREIGN KEY (sender_id) REFERENCES users(id) ON DELETE CASCADE,
        INDEX idx_chat (chat_id),
        INDEX idx_sender (sender_id),
        INDEX idx_created (created_at)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
    echo "<div class='alert alert-success'>✅ 'messages' টেবিল তৈরি হয়েছে!</div>";
    
    // Step 5: Insert default admin
    echo "<h4>৪. ডিফল্ট এডমিন ইউজার তৈরি হচ্ছে...</h4>";
    
    // Check if admin exists
    $stmt = $conn->query("SELECT COUNT(*) FROM admins WHERE username = 'admin'");
    $adminExists = $stmt->fetchColumn() > 0;
    
    if (!$adminExists) {
        $passwordHash = password_hash('admin123', PASSWORD_DEFAULT);
        $stmt = $conn->prepare("INSERT INTO admins (username, password, name, email, role) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute(['admin', $passwordHash, 'Admin User', 'admin@mathbaria.com', 'super_admin']);
        echo "<div class='alert alert-success'>✅ ডিফল্ট এডমিন ইউজার তৈরি হয়েছে!</div>";
    } else {
        // Update password to make sure it's correct
        $passwordHash = password_hash('admin123', PASSWORD_DEFAULT);
        $stmt = $conn->prepare("UPDATE admins SET password = ? WHERE username = 'admin'");
        $stmt->execute([$passwordHash]);
        echo "<div class='alert alert-info'>ℹ️ এডমিন ইউজার ইতিমধ্যে আছে, পাসওয়ার্ড আপডেট করা হয়েছে!</div>";
    }
    
    echo "<div class='alert alert-warning'><strong>লগইন তথ্য:</strong><br>";
    echo "Username: <code>admin</code><br>";
    echo "Password: <code>admin123</code></div>";
    
    $success = true;
    
} catch(PDOException $e) {
    echo "<div class='alert alert-danger'><strong>❌ ত্রুটি:</strong> " . htmlspecialchars($e->getMessage()) . "</div>";
    
    if (strpos($e->getMessage(), 'Access denied') !== false) {
        echo "<div class='alert alert-warning'>";
        echo "<strong>সমাধান:</strong><br>";
        echo "1. XAMPP Control Panel খুলুন<br>";
        echo "2. MySQL Start করুন<br>";
        echo "3. এই পেজ refresh করুন<br>";
        echo "</div>";
    } elseif (strpos($e->getMessage(), 'Connection refused') !== false || strpos($e->getMessage(), 'Connection refused') !== false) {
        echo "<div class='alert alert-warning'>";
        echo "<strong>সমাধান:</strong> MySQL সার্ভিস চালু নেই। XAMPP Control Panel থেকে MySQL Start করুন।<br>";
        echo "</div>";
    }
    
    $errors[] = $e->getMessage();
}

echo "<hr>";

if ($success) {
    echo "<div class='alert alert-success'><h4>✅ সফল!</h4>";
    echo "<p>ডাটাবেস এবং সব টেবিল সফলভাবে তৈরি হয়েছে!</p>";
    echo "<p><a href='login.php' class='btn btn-primary btn-lg'>এখন লগইন করুন</a></p>";
    echo "<p><a href='test_db.php' class='btn btn-secondary'>ডাটাবেস টেস্ট করুন</a></p>";
    echo "</div>";
} else {
    echo "<div class='alert alert-danger'><h4>❌ সমস্যা</h4>";
    echo "<p>ডাটাবেস তৈরি করতে সমস্যা হয়েছে। উপরের ত্রুটি বার্তা দেখুন।</p>";
    echo "<p><strong>চেক করুন:</strong></p>";
    echo "<ul>";
    echo "<li>XAMPP Control Panel থেকে MySQL Start করা আছে কিনা</li>";
    echo "<li>MySQL port (3306) অন্য কোনো প্রোগ্রাম ব্যবহার করছে কিনা</li>";
    echo "<li>api/config.php ফাইলে database credentials সঠিক কিনা</li>";
    echo "</ul>";
    echo "</div>";
}

echo "</div>";
echo "</div>";
echo "</div>";
echo "</body>";
echo "</html>";
?>

