<?php
require_once '../config.php';

$conn = getDBConnection();

// Get product ID from query parameter
$productId = $_GET['id'] ?? null;

if (!$productId) {
    sendResponse(false, 'Product ID is required', null, 400);
}

try {
    $query = "SELECT p.*, 
              GROUP_CONCAT(pi.image_path ORDER BY pi.image_order SEPARATOR ',') as images,
              u.name as seller_name
              FROM products p
              LEFT JOIN product_images pi ON p.id = pi.product_id
              LEFT JOIN users u ON p.seller_id = u.id
              WHERE p.id = :id
              GROUP BY p.id";
    
    $stmt = $conn->prepare($query);
    $stmt->execute([':id' => $productId]);
    $product = $stmt->fetch();
    
    if (!$product) {
        sendResponse(false, 'Product not found', null, 404);
    }
    
    // Process images
    $product['images'] = $product['images'] ? explode(',', $product['images']) : [];
    $product['images'] = array_map(function($img) {
        return UPLOAD_URL . $img;
    }, $product['images']);
    $product['price'] = (float)$product['price'];
    
    sendResponse(true, 'Product retrieved successfully', ['product' => $product]);
    
} catch(PDOException $e) {
    sendResponse(false, 'Failed to retrieve product: ' . $e->getMessage(), null, 500);
}

?>

